import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a new figure and axis
fig, ax = plt.subplots(figsize=(10, 8))

# Define colors for statuses
clear_color = 'limegreen'
not_clear_color = 'salmon'
hand_empty_color = 'deepskyblue'

# Draw the table
table = patches.Rectangle((0.05, 0.05), 0.9, 0.05, linewidth=1, edgecolor='black', facecolor='lightgray')
ax.add_patch(table)

# Draw blocks on the table
block_a = patches.Rectangle((0.1, 0.15), 0.15, 0.1, linewidth=1, edgecolor='black', facecolor=not_clear_color)
ax.add_patch(block_a)
ax.text(0.175, 0.2, 'a\nsupports', color='black', fontsize=8, ha='center', va='center')

block_b = patches.Rectangle((0.35, 0.15), 0.15, 0.1, linewidth=1, edgecolor='black', facecolor=not_clear_color)
ax.add_patch(block_b)
ax.text(0.425, 0.2, 'b\nsupports', color='black', fontsize=8, ha='center', va='center')

block_e = patches.Rectangle((0.6, 0.15), 0.15, 0.1, linewidth=1, edgecolor='black', facecolor=clear_color)
ax.add_patch(block_e)
ax.text(0.675, 0.2, 'e\nclear', color='black', fontsize=8, ha='center', va='center')

# Draw stacked blocks
block_d = patches.Rectangle((0.1, 0.25), 0.15, 0.1, linewidth=1, edgecolor='black', facecolor=clear_color)
ax.add_patch(block_d)
ax.text(0.175, 0.3, 'd\nclear', color='black', fontsize=8, ha='center', va='center')

block_c = patches.Rectangle((0.35, 0.25), 0.15, 0.1, linewidth=1, edgecolor='black', facecolor=clear_color)
ax.add_patch(block_c)
ax.text(0.425, 0.3, 'c\nclear', color='black', fontsize=8, ha='center', va='center')

# Draw the hand
hand = patches.Ellipse((0.85, 0.45), 0.1, 0.05, linewidth=1, edgecolor='black', facecolor=hand_empty_color)
ax.add_patch(hand)
ax.text(0.85, 0.45, 'hand\nempty', color='black', fontsize=8, ha='center', va='center')

# Create a legend
legend_elements = [
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Clear'),
    patches.Patch(facecolor=not_clear_color, edgecolor='black', label='Not Clear'),
    patches.Patch(facecolor=hand_empty_color, edgecolor='black', label='Hand Empty')
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.1, 1))

# Set limits and hide axes
ax.set_xlim(0, 1)
ax.set_ylim(0, 1)
ax.axis('off')

# Save the figure
plt.savefig('blocksworld/one_shot/ini_diagram_code/attempts/attempt_30.png', bbox_inches='tight')
plt.close()